* AED04.do March 2015 For Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED04.txt, text replace

********** OVERVIEW OF AED04.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need files
*  AED_SP500INDEX.DTA                 
*  AED_EARNINGS.DTA     This is sane as chapter 2
*  AED_HOUSING.DTA                    
*  AED_REALGDPPC.DTA 
* in your directory

********** SETUP **********

set more off
version 12
clear all
set mem 10m
* set linesize 82
* set scheme s2manual  /* Graphics scheme */
set scheme s1manual
************

* This STATA does analysis for Chapter 4
*   4.1 NATURAL LOGARITHM TRANSFORMATION
*   4.2 OTHER TRANSFORMATIONS

********* 4.1 NATURAL LOGARITHM TRANSFORMATION

** Figure 4.1 - two panels
clear
global nobs = 1000
set obs $nobs
generate x1 = -3 + _n/($nobs/6)
generate y1 = exp(x1)
generate x2 = 0 + _n/($nobs/10)
generate y2 = ln(x2)
graph twoway (line y2 x2), title("Natural logarithm function") ytitle("y = ln(x)") xtitle("x")
graph export AED04FIG1A.wmf, replace
graph twoway (line y1 x1), title("Exponential function") ytitle("y = exp(x)") xtitle("x")
graph export AED04FIG1B.wmf, replace

** FIGURE 4.2 - two panels
clear
use AED_SP500INDEX.DTA
describe
summarize
* To get exponential growth in the graph
regress lnsp500 year
predict plnsp500
* Following corrects for tretransformation bias - see chapter 12
generate psp500 = exp(plnsp500)*exp(e(rmse)^2/2)
graph twoway (line sp500 year) (line psp500 year), title("Exponential trend in levels") 
graph export AED04FIG2A.wmf, replace
graph twoway (line lnsp500 year) (lfit lnsp500 year), title("Linear trend in natural logarithms")
graph export AED04FIG2B.wmf, replace

*** FIGURE 4.3 - two panels
clear
use AED_EARNINGS.DTA
describe
summarize
generate lnearns = ln(earnings)
graph twoway (histogram earnings) (kdensity earnings, bw(10000)), title("Levels")
graph export AED04FIG3A.wmf, replace
graph twoway (histogram lnearns) (kdensity lnearns, bw(.4)), title("Natural logarithms")
graph export AED04FIG3B.wmf, replace

*** FIGURE 4.4 - two panels
clear
use AED_HOUSING.DTA
describe
summarize
* Shorten variable labels for figures
label variable exsales "Existing Home Sales"
label variable exsales_ma11 "11 month moving average"
label variable exsales_sa "Seasonally adjusted"
keep if year >= 2005
tsline exsales exsales_ma11, title("11 month moving average") 
graph export AED04FIG4A.wmf, replace
graph twoway (tsline exsales) (tsline exsales_sa), title("Seasonally adjusted")
graph export AED04FIG4B.wmf, replace

*** FIGURE 4.5 - two panels
clear
use AED_REALGDPPC.DTA
describe
summarize
* Shorten variable labels for figures
label variable gdp "Nominal GDP (billion $)"
label variable realgdp "Real GDP (2009 $)"
label variable gdppc "Nominal GDP per capita"
label variable realgdppc "Real GDP pc (2009 $)"
keep if year >= 1970
tsline gdp realgdp, title("Nominal GDP and Real GDP")
graph export AED04FIG5A.wmf, replace
tsline gdppc realgdppc, title("Nominal and real GDP per capita")
graph export AED04FIG5B.wmf, replace

********** CLOSE OUTPUT
log close


