* AED06.do March 2015 For Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED06.txt, text replace

********** OVERVIEW OF AED06.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_EARNINGS.DTA    Same as chapter 2
*   AED_GASPRICE.DTA
*   AED_EARNINGSMALE.DTA
*   AED_INFLATION.DTA
* in your directory

********** SETUP **********

set more off
version 12
clear all
set mem 10m
* set linesize 82
set scheme s1manual  /* Graphics scheme */

************

* This STATA program does analysis for Chapter 6
*   6.1 t DISTRIBUTION
*   6.2 EXAMPLE: EARNINGS
*   6.3 CONFIDENCE INTERVALS
*   6.4 TWO-SIDED HYPOTHESIS TESTS
*   6.5 TEST POWER
*   6.6 EXAMPLES

********** DATA DESCRIPTION

*     Annual Earnings for 171 women + 191 men aged 30 years in 2010 Full-time workers
*     362 observations on 4 variables

****  6.1 t DISTRIBUTION

* Figure 6.1 - created elsewhere

* Figure 6.2 - created elsewhere

**** 6.2 EXAMPLE 

**** 6.3 CONFIDENCE INTERVALS

clear
use AED_EARNINGS.DTA
summarize
* 95% Confidence interval
mean earnings
* 90% and 99% confidence intervals
mean earnings, level(90)
mean earnings, level(99)

**** 6.4 TWO-SIDED HYPOTHESIS TEST

clear
use AED_EARNINGS.DTA
summarize earnings, detail
mean earnings
* Test H0: mu = 40000 against HA: mu not = 40000 using Stata command ttest
* This also does one-sided tests - in both directiosn.
ttest earnings = 40000

* Figure 6.3 - created elsewhere

**** 6.5 EXAMPLES

* Gasoline price example
clear
use AED_GASPRICE.DTA
describe
summarize
ttest price = 3.81

* Male Earnings
clear
use AED_EARNINGSMALE.DTA
describe
summarize
summarize, detail
* Test H0: mu >= 40000 against HA: mu < 40000
ttest earnings = 40000

* Inflation
clear
use AED_INFLATION.DTA
describe 
sum
ttest inflation = 3.0

* Note effect of serial correlation
tsset date
corrgram inflation
regress inflation
newey inflation, lag(21)
prais inflation, corc

********** CLOSE OUTPUT
log close



