* AED09.do March 2015 For Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED09.txt, text replace

********** OVERVIEW OF AED09.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_HOUSE.DTA     Same as chapter 8
*   AED_SAMPLEFIVE.DTA
*   AED_400REGRESSiONS.DTA
* in your directory

********** SETUP **********

set more off
version 12
clear all
set mem 10m
* set linesize 82
set scheme s1manual  /* Graphics scheme */

************

* This STATA does analysis for Chapter 9
*  9.1 EXAMPLE: HOUSE PRICE AND SIZE
*  9.2 POPULATION AND SAMPLE
*  9.3 EXAMPLES OF SAMPLING FROM A POPULATION
*  9.6 ROBUST STANDARD ERRORS
*  9.C REGRESSION IWTH DEMEANED DATA

********** DATA DESCRIPTION

* House sale price for 29 houses in Central Davis in 1999
*     29 observations on 9 variables 

****  9.1 EXAMPLE: HOUSE PRICE AND SIZE

use AED_HOUSE.dta, clear
summarize
regress price size

* Figure 9.1 - created elsewhere

****  9.2 POPULATION AND SAMPLE

clear 
use AED_SAMPLEFIVE.DTA 
describe 
summarize

* Table 9.1
list

* Figure 9.2 - two panels
regress y x
twoway (scatter y x) (lfit ytrue x), title("True regression line") legend(off)
graph export AED09FIG2A.wmf, replace 
twoway (scatter y x) (lfit y x), title("Fitted regression line") legend(off)
graph export AED09FIG2B.wmf, replace 

****  9.3 EXAMPLES OF SAMPLING FROM A POPULATION

* Figure 9.3 - panel 1 (of 3)
clear
set obs 30
set seed 123456
generate x = rnormal(3,1)
generate u = rnormal(0,2)
generate y = 1 + 2*x + u
graph twoway (scatter y x) (lfit y x), title("Sample 1") 
graph export AED09FIG3A.wmf, replace

* Figure 9.4 - two panels
clear 
use AED_400REGRESSIONS.DTA
describe
summarize
* label variable slope "Regression slope coefficient"
* label variable slope "Regression intercept"
graph twoway (histogram slope) (kdensity slope), title("Generated data: 400 Slopes")
graph export AED09FIG4A.wmf, replace
graph twoway (histogram intercept) (kdensity intercept), title("Generated data: 400 Intercepts") 
graph export AED09FIG4B.wmf, replace

* Figure 9.5 - created elsewhere

***** APPENDIX 9.C

* Show that regression with demeaned data gives same slope coefficient
clear
use AED_HOUSE.DTA
egen ymean = mean(price)
generate ydiff = price - ymean
egen xmean = mean(size)
generate xdiff = size - xmean
regress ydiff xdiff
regress ydiff xdiff, vce(robust)

********** CLOSE OUTPUT
log close


