* AED10.do March 2015 For Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED10.txt, text replace

********** OVERVIEW OF AED10.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_HOUSE.DTA   Same as chapter 8
*   AED_INFLATION.DTA
* in your directory

********** SETUP **********

set more off
version 12
clear all
set scheme s1manual  // Graphics scheme

************

* This STATA does analysis for Chapter 10
*   10.1 EXAMPLE: HOUSE PRICE AND SIZE
*   10.2 THE T STATISTIC
*   10.3 CONFIDENCE INTERVALS
*   10.4 TESTS OF STATISTICAL SIGNIFICANCE
*   10.5 TWO-SIDED HYPOTHESIS TESTS
*   10.6 ONE-SIDED HYPOTHESIS TESTS
*   10.7 ROBUST STANDARD ERRORS
*   10.8 PRESENTATION OF REGRESSION OUTPUT   
*   10.9 PREDICTION
*   10.10 EXAMPLES

********** DATA DESCRIPTION

* House sale price for 29 houses in Central Davis in 1999
*     29 observations on 9 variables 

**** 10.1 EXAMPLE: HOUSE PRICE AND SIZE

clear
use AED_HOUSE.DTA
summarize

* Table 10.1
regress price size

**** 10.3 CONFIDENCE INTERVALS

* Example with artifical data
clear
input x y 
 1 1
 2 2
 3 2
 4 2
 5 3
end
regress y x

***** 10.4 TESTS OF STATISTICAL SIGNIFICNACE

clear
use AED_HOUSE.DTA
regress price size

**** 10.5, 10.6 TWO-SIDED AND ONE-SIDED HYPOTHESIS TESTS

regress price size
ttest size = 90

* Figure 10.1 - created elsewhere

****  10.7 INFERENCE WITH ROBUST STANDARD ERRORS

* Table 10.4
clear
use AED_HOUSE.DTA
regress price size, vce(robust)

clear
use AED_INFLATION.DTA
describe
summarize
sum infl
corrgram infl
regress infl
newey infl, lag(31)

****  10.8 PRESENTATION OF REGRESSION OUTPUT   

* Table 10.4
clear
use AED_HOUSE.DTA
regress price size
estimates store OUTPUT
estimates table OUTPUT, b(%11.2f) se(%11.2f) stats(r2 N)
estimates table OUTPUT, b(%11.2f) t(%11.2f) stats(r2 N)
estimates table OUTPUT, b(%11.2f) p(%11.3f) stats(r2 N)
estimates table OUTPUT, b(%11.2f) star(.10 .05 .01) stats(r2 N)

****  10.9 PREDICTION

* Predict conditional mean for house size = 2000 and get confidence interval
* This uses Stata command lincom
clear
use AED_HOUSE.DTA
regress price size
lincom _cons + size*2000

* Predict conditional mean for house size = 2000 and get confidence interval
* And forecast actual value for house size = 2000
* Do manually as was done in book
quietly summarize size
scalar xbar = r(mean)
scalar n = r(N)
scalar sumxminusxbarsq = (r(N)-1)*r(Var)
quietly regress price size
scalar b1 = _b[_cons]
scalar b2 = _b[size]
scalar s_e = e(rmse)
scalar y_cm = b1 + 2000*b2
scalar y_f = b1 + 2000*b2
scalar s_y_cm = s_e*sqrt(1/n+(2000-xbar)^2/sumxminusxbarsq)
scalar s_y_f = s_e*sqrt(1+1/n+(2000-xbar)^2/sumxminusxbarsq)
scalar tcrit = invttail(n-2,.025)

* Conditional mean at size = 2000
display "yhat = " y_cm _n "t critical value = " tcrit _n  
display "Se for cond mean = " s_y_cm _n "CI width " = tcrit*s_y_cm _n 
display "95% confidence interval: (" y_cm-tcrit*s_y_cm ", " y_cm+tcrit*s_y_cm ")"

* Actual value at size = 2000
display "yhat = " y_f _n "t critical value = " tcrit _n 
display "Se for actual value = " s_y_f _n  "CI width " = tcrit*s_y_f
display "95% confidence interval: (" y_f-tcrit*s_y_f ", " y_f+tcrit*s_y_f ")"

****   10.10 EXAMPLES

********** CLOSE OUTPUT

log close


