* AED11.do March 2015 For Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED11.txt, text replace

********** OVERVIEW OF AED11.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_CAPM.DTA
*   AED_GDPUNEMPLOY.DTA
*   AED_HEALTH2009.DTA
* in your directory

********** SETUP **********

set more off
version 12
clear all
set mem 10m
* set linesize 82
set scheme s1manual  /* Graphics scheme */

************

* This STATA does analysis for Chapter 11
*  11.1 CAPM MODEL
*  11.2 OKUNS LAW
*  11.3 HEALTH OUTCOMES AND HEALTH EXOENDITURES
*  11.4 HEALTH EXPENDITURES AND GDP 

********** 11.1 CAPM MODEL

* Read in data
clear
use AED_CAPM.DTA
summarize
list in 1, clean

* Table 11.1
sum date rf ko tgt wmt mkt_rf ko_rf tgt_rf wmt_rf  

tsset date
format date %tmCCYY

** Figure 11.1  - two panels
* Coca Cola & Market
* Shorten variable label for figure
label variable ko_rf "Coca Cola excess return"
label variable mkt_rf "Market excess return"
twoway (tsline ko_rf if date > 564) (tsline mkt_rf if date > 564), title("Excess Returns over Time")
graph export AED11FIG1A.wmf, replace 
twoway (scatter ko_rf mkt_rf) (lfit ko_rf mkt_rf), title("Coca Cola versus Market")
graph export AED11FIG1B.wmf, replace 

* Coca Cola regression results
regress ko_rf mkt_rf 
estimates store KO_def
predict ko_res, res
regress ko_rf mkt_rf, vce(robust)
estimates store KO_rob
regress ko_rf mkt_rf mkt_rf_sq, vce(robust)
estimates store KO_quad
newey ko_rf mkt_rf, lag(13)
estimates store KO_newey

* Residual correlations
pwcorr ko_res l.ko_res l2.ko_res l3.ko_res

**** 11.2 OKUN'S LAW

* Read in data
clear
use AED_GDPUNEMPLOY.DTA
summarize
list in 1, clean

* Table 11.2 
sum rgdpgrowth uratechange

* Regression 
regress rgdpgrowth uratechange
predict pgrowth
predict resgrowth, res

** Figure 11.2 - two panels
twoway (scatter rgdpgrowth uratechange) (lfit rgdpgrowth uratechange), title("Scatterplot of data")
graph export AED11FIG2A.wmf, replace 
twoway (line rgdpgrowth year) (line pgrowth year), title("Real GDP Change over Time") 
graph export AED11FIG2B.wmf, replace 

* Corrgram for levels and changes and residuals
corrgram rgdp2009, lag(10)
corrgram rgdp2009, lag(10)
corrgram resgrowth, lag(10)

* HAC standard errors
newey rgdpgrowth uratechange, lag(5)

* Het robust standard errors 
regress rgdpgrowth uratechange, vce(robust)

********** 11.3 HEALTH OUTCOMES 

* Read in data
clear
use AED_HEALTH2009.DTA
summarize

* Table 11.3
sum gdppc lifeexp infmort

* Linear model
regress lifeexp hlthpc
predict plinlifeexp
* Heteroskedastic robust standard errors
regress lifeexp hlthpc, vce(robust)

* Log-log model
regress lnlifeexp lnhlthpc
predict plnlifeexp
generate ploglifeexp = exp(e(rmse)^2/2)*exp(plnlifeexp)

sum lifeexp plinlifeexp ploglifeexp
cor lifeexp plinlifeexp ploglifeexp
twoway (scatter lifeexp hlthpc) (scatter ploglifeexp hlthpc) (lfit lifeexp hlthpc)
regress lnlifeexp lnhlthpc, vce(robust)

** Figure 11.3 - two panels
twoway (scatter lifeexp hlthpc) (lfit lifeexp hlthpc), title("Linear model") 
graph export AED11FIG3A.wmf, replace 
sort ploglifeexp
twoway (scatter lifeexp hlthpc) (line ploglifeexp hlthpc), title("Prediction from log-log model")
graph export AED11FIG3B.wmf, replace 

* Check role of outliers in levels
regress lifeexp hlthpc 
estimates store all
regress lifeexp hlthpc, vce(robust)
estimates store allrob
regress lifeexp hlthpc if code != "USA"
estimates store noUS
regress lifeexp hlthpc if code != "USA", vce(robust)
estimates store noUSrob
estimates table all allrob noUS noUSrob, b(%11.4f) se(%11.4f) t(%11.2f) stat(N r2 r2_a rmse F) 

* Check role of outliers in logs
regress lnlifeexp lnhlthpc 
estimates store all
regress lnlifeexp lnhlthpc, vce(robust)
estimates store allrob
regress lnlifeexp lnhlthpc if code != "USA"
estimates store noUS
regress lnlifeexp lnhlthpc if code != "USA", vce(robust)
estimates store noUSrob
estimates table all allrob noUS noUSrob, b(%11.4f) se(%11.4f) t(%11.2f) stat(N r2 r2_a rmse F) 

********** 11.4 HEALTH EXPENDITURES and GDP

clear
use AED_HEALTH2009.DTA

** Table 11.4
sum gdppc hlthpc

* List data
list country gdppc hlthpc hlthgdp lifeexp infmort

* Figure 11.4 - two panels
twoway (scatter hlthpc gdppc) (lfit hlthpc gdppc), title("Linear model")
graph export AED11FIG4A.wmf, replace 
twoway (scatter lnhlthpc lngdppc) (lfit lnhlthpc lngdppc), title("Natural Logarithms model") 
graph export AED11FIG4B.wmf, replace 

* Linear regression
regress hlthpc gdppc
predict plinhlthpc
* Heteroskedastic robust
regress hlthpc gdppc, vce(robust)

* Log-linear regression
regress lnhlthpc lngdppc
test lngdppc = 1
predict plnhlthpc
generate ploghlthpc = exp(e(rmse)^2/2)*exp(plnhlthpc)
sum hlthpc plinhlthpc ploghlthpc
cor hlthpc plinhlthpc ploghlthpc
* Heteroskedastic robust standard errors
regress lnhlthpc lngdppc, vce(robust)

********** CLOSE OUTPUT
log close


