* AED13.do March 2015 for Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED13.txt, text replace

********** OVERVIEW OF AED13.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_HOUSE.DTA   Same as chapter 8
* in your directory

********** SETUP **********

set more off
version 12
clear all
set mem 10m
* set linesize 82
set scheme s1manual  /* Graphics scheme */

************

* This STATA does analysis for Chapter 13
*  13.1 EXAMPLE: HOUSE PRICE AND CHARACTERISTICS
*  13.2 TWO-WAY SCATTERPLOTS
*  13.3 CORRELATION
*  13.4 REGRESSION LINE
*  13.5 ESTIMATED PARTIAL EFFECTS 
*  13.6 MODEL FIT
*  13.7 COMPUTER OUTPUT

********** DATA DESCRIPTION

* House sale price for 29 houses in Central Davis in 1999
*     29 observations on 9 variables 

****  13.1 EXAMPLE: HOUSE PRICE AND CHARACTERISTICS

use AED_HOUSE.DTA
describe

* Table 13.1
summarize price size bedrooms bathroom lotsize age monthsold

* Table 13.2
list price size bedrooms bathroom lotsize age monthsold, clean

* Regression with and without control
regress price bedrooms
regress price bedrooms size

****   13.2 TWO-WAY SCATTERPLOTS

* Figure 13.1 
graph matrix price size bedrooms age, scale(1.2)
graph export AED13FIG1.wmf, replace

****  13.3 CORRELATION

* Table 13.3
correlate price size bedrooms bathroom lotsize age monthsold
pwcorr price size bedrooms bathroom lotsize age monthsold, sig star(.05)
set textsize 150

****  13.4 REGRESSION LINE

use AED_HOUSE.DTA

* Multivariate regression
regress price size bedrooms bathroom lotsize age monthsold

* Demonstrate that can get from bivariate regression on a residual
* First regress size on all other regressors to get the residual
regress size bedrooms bathroom lotsize age monthsold
predict res_size, resid
* regress price on the residual
regress price res_size

****  13.5 ESTIMATED PARTIAL EFFECTS 

* Partial Effects
regress size bedrooms
scalar dsdb = _b[bedrooms]
regress price bedrooms size
scalar totaleffect = _b[bedrooms] + _b[size]*dsdb
di "total effect " totaleffect
regress price bedrooms

* Same adding a regressor 
regress size bedrooms
scalar dsdb = _b[bedrooms]
regress age bedrooms
scalar dadb = _b[bedrooms]
regress price bedrooms size age
scalar totaleffect = _b[bedrooms] + _b[size]*dsdb + _b[age]*dadb
di "total effect " totaleffect
regress price bedrooms

*****  13.6 MODEL FIT

regress price size bedrooms bathroom lotsize age monthsold

* R-squared is squared correlation between yhat and y
regress price size bedrooms bathroom lotsize age monthsold
di e(r2)
predict pprice
correlate price pprice
di r(rho)^2

* Compute adjusted R-squared
di "Adjusted R-squared = " e(r2) - (e(df_m)/e(df_r))*(1-e(r2))

* Information criteria
estat ic

* Information criteria manually
di "AIC = " e(N)*ln(e(rss)/e(N)) + e(N)*(1+ln(2*_pi)) + 2*e(rank)
di "BIC = " e(N)*ln(e(rss)/e(N)) + e(N)*(1+ln(2*_pi)) + e(rank)*ln(e(N))


*****  13.7 COMPUTER OUTPUT

* Table 13.4
regress price size bedrooms bathroom lotsize age monthsold

********** CLOSE OUTPUT
log close

