* aed14.do March 2015 for Stata version 12 

capture log close   // capture means program continues even if no log file open
log using aed14.txt, text replace

********** OVERVIEW OF aed14.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_HOUSE.DTA   Same as chapter 8
* in your directory

********** SETUP **********

set more off
version 12
clear all
set mem 10m
* set linesize 82
set scheme s1manual  /* Graphics scheme */

************

* This STATA does analysis for Chapter 13
*  14.1 PROPERTIES OF OLS ESTIAMTES
*  14.2 POINT ESTIMATION
*  14.3 CONFIDENCE INTERVALS
*  14.4 HYPOTHESIS TESTS ON A SINGLE PARAMETER
*  14.5 HYPOTHESIS TESTS ON SEVERAL PARAMETERS
*  14.6 ROBUST STANDARD ERRORS
*  14.7 OTHER LEAST SQUARES ESTIAMTES
*  14.8 PREDICTION

********** DATA DESCRIPTION

* House sale price for 29 houses in Central Davis in 1999
*     29 observations on 9 variables 

****  14.1 - 14.4 EXAMPLE: HOUSE PRICE AND CHARACTERISTICS

use AED_HOUSE.DTA
describe
summarize price size bedrooms bathroom lotsize age monthsold

* Table 14.2
* Multivariate regression
regress price size bedrooms bathroom lotsize age monthsold

* Test that beta_size = 50
test size = 50
di "tstatistic = " sqrt(r(F))

* Test manually
scalar tstatistic = (_b[size] - 50)/_se[size]
di "tstatistic = " tstatistic " and p-value = " 2*ttail(e(df_r),tstatistic)

****  14.5 HYPOTHESIS TESTS ON SEVERAL PARAMETERS

* Figure 14.1 - created elsewhere

* Table 14.3
di "Row 1: " invFtail(1,30,.10)  "  " invFtail(2,30,.10)  "  "  invFtail(3,30,.10) "  " invFtail(10,30,.10)  "  "  invFtail(20,30,.10)
di "Row 2: " invFtail(1,10000,.10)  "  " invFtail(2,10000,.10)  "  "  invFtail(3,10000,.10) " " invFtail(10,10000,.10)  "  "  invFtail(20,10000,.10)
di "Row 3: " invFtail(1,30,.05)  "  " invFtail(2,30,.05)  "  "  invFtail(3,30,.05)  " invFtail(10,30,.05)  "  "  invFtail(20,30,.05)
di "Row 4: " invFtail(1,10000,.05)  "  " invFtail(2,10000,.05)  "  "  invFtail(3,10000,.05) " " invFtail(10,10000,.05)  "  "  invFtail(20,10000,.05)
di "Row 5: " invFtail(1,30,.01)  "  " invFtail(2,30,.01)  "  "  invFtail(3,30,.01)  " invFtail(10,30,.01)  "  "  invFtail(20,30,.01)
di "Row 6: " invFtail(1,10000,.01)  "  " invFtail(2,10000,.01)  "  "  invFtail(3,10000,.01) " " invFtail(10,10000,.01)  "  "  invFtail(20,10000,.01)

clear
use AED_HOUSE.DTA

* Overall F test can be read directly using output
quietly regress price size bedrooms bathroom lotsize age monthsold
test bedrooms bathroom lotsize age monthsold

* Overall F test manually
quietly regress price size bedrooms bathroom lotsize age monthsold
scalar Foverall = (e(mss)/e(df_m)) / (e(rss)/e(df_r))
di "F overall = " Foverall " with p = " Ftail(e(df_m),e(df_r),Foverall) 

* Subset test can be done using command test
quietly regress price size bedrooms bathroom lotsize age monthsold
test bedrooms bathroom lotsize age monthsold

* Subset test done manually
quietly regress price size bedrooms bathroom lotsize age monthsold
scalar RSSu = e(rss)
scalar ku = e(df_m) + 1
scalar nminusku = e(df_r)
quietly regress price size
scalar RSSr = e(rss)
scalar kr = e(df_m) + 1
scalar Fsubset = ((RSSr-RSSu)/(ku-kr)) / (RSSu/nminusku)
di "F subset = " Fsubset " with p = " Ftail(ku-kr,nminusku,Fsubset) " and (q,n-k) = " ku-kr " , " nminusku

* Test of single regressor statistical significance
regress price size bedrooms bathroom lotsize age monthsold
test size
di "Square root of F(1,n-k) equals t-test: " sqrt(r(F))


*****  14.6 ROBUST STANDARD ERRORS

* Table 14.5
regress price size bedrooms bathroom lotsize age monthsold, vce(robust)

*****  14.8 PREDICTION

* Predict conditional mean for size = 2000,  and get confidence interval
quietly regress price size bedrooms bathroom lotsize age monthsold
scalar s_e = e(rmse)
scalar n = e(N)
scalar k = e(rank)
lincom _b[_cons] + _b[size]*2000 + _b[bedrooms]*4  + _b[bathroom]*2  + _b[lotsize]*2 + _b[age]*40  + _b[monthsold]*6 
scalar y_f = r(estimate)
scalar s_y_cm = r(se)
scalar s_y_f = sqrt(s_e^2 + s_y_cm^2)
scalar tcrit = invttail(n-k,.025)
* 95% confidence interval for conditional mean
display "y_cm = " y_f _n "t critical value = " tcrit _n ///
  "Se for actual value = " s_y_cm _n  "CI width " = tcrit*s_y_cm ///
  "95% confidence interval: (" y_f-tcrit*s_y_cm ", " y_f+tcrit*s_y_cm ")"
* 95% confidence interval for forecast actual value
display "y_f = " y_f _n "t critical value = " tcrit _n ///
  "Se for actual value = " s_y_f _n  "CI width " = tcrit*s_y_f ///
  "95% confidence interval: (" y_f-tcrit*s_y_f ", " y_f+tcrit*s_y_f ")"

* Repeat for het robust se's
* Just confidence interval for conditional mean
quietly regress price size bedrooms bathroom lotsize age monthsold, vce(robust)
lincom _b[_cons] + _b[size]*2000 + _b[bedrooms]*4  + _b[bathroom]*2  + _b[lotsize]*2 + _b[age]*40  + _b[monthsold]*6 

********** CLOSE OUTPUT
log close


