# racd05.R  March 2012 for R version 2.15.0

# Create log file
sink("racd05.Rout")

rm(list=ls())

# ********** OVERVIEW OF racd05.R **********

# R Program 
# copyright C 2012 by A. Colin Cameron and Pravin K. Trivedi 
# used for "Regression Analyis of Count Data" SECOND EDITION
# by A. Colin Cameron and Pravin K. Trivedi (2012)
# Cambridge University Press

# To run you need file
#   racd05data.dta
# and R packages
#   foreign, sandwich, pscl  

# This R does analysis of takeover bids studied in chapter 5
# (The Stata program racd05.do does more)
#  5.2 RESIDUALS
#  5.3 GOODNESS-OF-FIT
 
# ********* DATA DESCRIPTION

# The original data are from Sanjiv Jaggia and Satish Thosar, 1993,
# "Multiple Bids as a Consequence of Target Management Resistance"
# Review of Quantitative Finance and Accounting, 447-457.
# The data are also used in 
# A.C. Cameron and Per Johansson (1997), 
# "Count Data Regression Models using Series Expansions: with Applications", 
# Journal of Applied Econometrics, May, Vol. 12, pp.203-223.

# For more details see these datasets and racd05makedata.dta

# ********* 5.2 READ DATA AND SUMMARIZE 

# install.packages("foreign")
library(foreign)
data.ch5 <- read.dta(file = "racd05data.dta")
# Allows variables in database to be accessed simply by giving names
attach(data.ch5)   
# Lists first six observations
head(data.ch5)

# *** TABLE 5.1: FREQUENCIES

# Tabulate counts of doctor visits
table(NUMBIDS)
table(NUMBIDS) / nrow(data.ch5)

# *** TABLE 5.2: VARIABLE SUMMARY STATISTICS

# Variable list
names(data.ch5)

# Summary statistics
summary(data.ch5)
sapply(data.ch5,mean)
sapply(data.ch5,sd)

# Formula for the model estimated in this chapter - shortens the commands below
formula.ch5model <- as.formula(NUMBIDS ~ LEGLREST+REALREST+FINREST+WHTKNGHT
                     +BIDPREM+INSTHOLD+SIZE+SIZESQ+REGULATN)

# ********** 5.2 RESIDUALS

# Poisson with NB1 standard errors (variance is a multiple of the mean)
model.poiss <- glm(formula.ch5model, family=quasipoisson()) 
summary(model.poiss)

# Poisson with robust standard errors 
# install.packages("sandwich") 
library(sandwich)
cov.robust <- vcovHC (model.poiss, type="HC0")
se.robust <- sqrt(diag(cov.robust))
coeffs <- coef(model.poiss)
t.robust <- coeffs / se.robust
results <- cbind(coeffs, se.robust, t.robust, pvalue=round(2*(1-pnorm(abs(coeffs/se.robust))),5), 
           lower=coeffs-1.96*se.robust, upper=coeffs+1.96*se.robust)    

# TABLE 5.3: POISSON QMLE
results

# Various residuals
yhat <- fitted.values(model.poiss)
raw <- NUMBIDS - yhat
pears <- raw/sqrt(yhat)
dev <- residuals(model.poiss)
anscombe <- 1.5*(NUMBIDS^(2/3) - yhat^(2/3)) / yhat^(1/6)
residuals <- cbind(raw,pears,dev,anscombe)

# TABLE 5.4: RESIDUALS SUMMARY
summary(residuals)

# TABLE 5.5: RESIDUALS CORRELATION
cor(residuals)

# ********** 5.3 GOODNESS OF FIT

# Pearson and Deviance statistics
pearson.statistic <- sum(pears^2)
deviance.statistic <- deviance(model.poiss)
cbind(pearson.statistic, deviance.statistic)

# Various R-sqaureds
pearson.null <- sum( (NUMBIDS-mean(NUMBIDS))^2 / mean(NUMBIDS) )
# deviance.null <-  model.poiss#null.deviance   # gives more than just deviance
one <- matrix(1,nrow=nrow(data.ch5),ncol=1)
model.poiss.null <- glm(NUMBIDS ~ one , family=quasipoisson())
deviance.null <- deviance(model.poiss.null)
R2.pearson <- 1 - pearson.statistic/pearson.null
R2.deviance <- 1 - deviance.statistic / deviance.null
R2.corr <- corr(cbind(NUMBIDS,yhat))^2
cbind(pearson.null, deviance.null)
cbind(R2.pearson, R2.deviance, R2.corr)

# Predicted probabilities - This is matrix N times (maxy - miny + 1)
# install.packages("pscl")
library(pscl)
model.poissdef <- glm(formula.ch5model, family=poisson())
ppoiss <- predprob(model.poissdef)
ppoissave <- colMeans(ppoiss)
relfreqs <- table(NUMBIDS) / nrow(data.ch5)

# TABLE 5.6: PREDICTED AND ACTUAL PROBABILITIES
relfreqs
ppoissave

# close log file
sink()
