* AED02.do March 2015 For Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED02.txt, text replace

********** OVERVIEW OF AED02.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_EARNINGS.DTA
*   AED_REALGDPPC_CH2.DTA 
*   AED_HEALTHCAT.DTA
*   AED_FISHING.DTA
* in your directory

********** SETUP **********

set more off
version 12
clear all
set scheme s1manual  /* Graphics scheme */

************

* This STATA does analysis for Chapter 2
*   2.1 SUMMARY STATISTICS FOR NUMERICAL DATA 
*   2.2 CHARTS FOR NUMERICAL DATA
*   2.3 CATEGORICAL DATA 
*   2.4 CHARTS FOR NUMERICAL DATA BY CATEGORY
 
********** DATA DESCRIPTION

* (1) Annual Earnings for 191 women aged 30 years in 2010 Full-time workers
*     191 observations on 4 variables
* (2) U.S. GDP Growth Rate and Inflation 1929 to 2011
*     83 Observations on 4 variables
* (3) Fishing site data 
*     1182 observations on ?? variables
* (4) U.S. Health Expenditures in 1997
*     11 Observations on 2 variables

****   2.1 SUMMARY STATISTICS FOR NUMERICAL DATA 

* Read in data
clear
use AED_EARNINGS.DTA
summarize

* Table 2.1
summarize earnings, detail

* Figure 2.1 - not included

* Figure 2.2
clear
set obs 10000
set seed 10101
* x is symmetric, y is right-skewed, z is left-skewed.
gen x = rnormal(3,1)
gen y = exp(0.5*x)/3
gen z = 1 + 2.5*ln(x)
tabstat x y z, stat (count mean p50 sd skewness kurtosis)

* Figure 2.2 - three panels
histogram x if x > 0 & x < 6, start(0) width(0.2) frequency title("Symmetric")
graph export AED02FIG2A.wmf, replace
histogram y if y > 0 & y < 6, start(0) width(0.2) frequency title("Right-skewed")
graph export AED02FIG2B.wmf, replace
histogram z if z > 0 & z < 6, start(0) width(0.2) frequency title("Left-skewed")
graph export AED02FIG2C.wmf, replace

* Figure 2.3
clear
use AED_EARNINGS.DTA
label variable earnings "Annual earnings (in dollars)"
graph box earnings
graph export AED02FIG3.wmf, replace

**** 2.2  CHARTS FOR NUMERICAL DATA 

* Table 2.2
clear
use AED_EARNINGS.DTA
tabulate earnings
generate earningsrange = int(earnings/15000)
tabulate earningsrange

* Figure 2.4 - two panels
histogram earnings, start(0) width(15000) frequency title("Default bin width")
graph export AED02FIG4A.wmf, replace
histogram earnings, start(0) width(7500) frequency title("Wider bin width")
graph export AED02FIG4B.wmf, replace

* Figure 2.5 - two panels
kdensity earnings, bwidth(5000) title("Default window width")
graph export AED02FIG5A.wmf, replace
kdensity earnings, bwidth(10000) title("Wider window width")
graph export AED02FIG5B.wmf, replace

* Figure 2.6
clear 
use AED_REALGDPPC_CH2
tsline pcrgdp, yline(10000 20000 30000 40000, lstyle(grid)) scale(1.3)
graph export AED02FIG6.wmf, replace

**** 2.3 CATEGORICAL DATA 

clear
use AED_FISHING.DTA

* Table 2.3
tabulate mode

* Figure 2.7
graph pie one, over(mode) plabel(_all name, gap(-8)) plabel(_all percent)
graph export AED02FIG7.wmf, replace

**** 2.4  CHARTS FOR NUMMERICAL DATA BY CATEGORY

clear
use AED_HEALTHCAT.DTA
summarize

* Table 2.5
list

* Figure 2.8
graph bar expenditures, over(category)
graph bar expenditures, over(category, label(angle(45)) sort(expenditures) descending) ///
  ytitle("Expenditures (in $ billions)") scale(1.3) 
graph export AED02FIG8.wmf, replace

********** CLOSE OUTPUT
log close


