* AED03.DO March 2015 For Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED03.txt, text replace

********** OVERVIEW OF AED03.DO **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need files
*     AED_OUTPUTANNUAL.DTA
*     AED_INFLATIONANNUAL.DTA
*     AED_LABORFOREMONTHLY.DTA
*     AED_INTRATESQUARTERLY.DTA
* in your directory

**********

* This STATA program does analysis for Chapter 3
*   3.1 OUTPUT MEASURES
*   3.2 PRICES 
*   3.3 LABOR FORCE STATISTICS
*   3.4 FINANCIAL DATA: INTEREST RATES and STOCK INDEXES

********** SETUP **********

set more off
version 12
clear all
set mem 10m
* set linesize 82
set scheme s1manual  /* Graphics scheme */

*****   3.1 OUTPUT MEASURES

** Figure 3.1 - Annual GDP Growth from 1930
clear
use AED_OUTPUTANNUAL.DTA
describe 
summarize
* Following uses knowledge that mean GROWTH is 3.3%
tsline growthrate, yline(3.3) title("Annual growth rate in real GDP from 1930")
graph export AED03FIG1.wmf, replace
sum growthrate if year > 1973

*****   3.2 PRICES 

** Figure 3.2 - Annual CPI Inflation from 1930
clear
use AED_INFLATIONANNUAL.DTA
describe
summarize
sum inflation
local aveinfl = r(mean)
* Following uses knowledge that obs ?? is 1930
tsline inflation, yline(`aveinfl') title("Annual CPI-U price inflation from 1930") 
graph export AED03FIG2.wmf, replace

* Extra for Chapter 7.4
corrgram inflation, lag(10)
pwcorr inflation L.inflation L2.inflation L3.inflation L4.inflation
corr inflation L.inflation L2.inflation L3.inflation L4.inflation
corr inflation L.inflation
corr inflation L2.inflation
corr inflation L3.inflation
corr inflation L4.inflation

* Table 3.2
sum cpi
list cpi if year == 1930
gen dollar1930 = cpi/17.1
list cpi if year == 2013
gen dollar2013 = cpi/230.28
list year dollar1930 dollar2013 if year==1930 | year==1950 | ///
   year==1970 | year==1990 | year==2010 | year==2013

*****   3.3 LABOR FORCE STATISTICS

clear
use AED_LABORFORCEMONTHLY.DTA

* Data for graphs uses 1948 on.
* Following uses knowledge that obs 109 is 1948Jan
keep if _n > 108

twoway tsline PAYEMS CE16OV, title("U.S. employment since 1948")
graph export AED03FIG3.wmf, replace

** Figure 3.4 Various Unemployment Rates (seasonally adjusted)
gen UNRATE27OV = 100*UEMP27OV/CLF16OV
* Shorten variable labels for graphs 
label variable UNRATE "Base Rate"
label variable UNRATE27OV "Long-term"
label variable U6RATE "Underemployed"
tsline UNRATE UNRATE27OV U6RATE, title("U.S. unemployment rates since 1948") 
graph export AED03FIG4.wmf, replace

** Figure 3.5 Labor Force Particpation Rate (seasonally adjusted)
* Shorten variable labels for graphs 
label variable CIVPART "Civilian LFP Rate All years"
label variable LNS11300060 "Civilian LFP Rate 25-54 years"
tsline CIVPART LNS11300060, ytitle("U.S. labor force participation rate since 1948") 
graph export AED03FIG5.wmf, replace

*****   3.4 FINANCIAL DATA: INTEREST RATES and STOCK INDEXES

** Figure 3.6 Interest Rates
clear
use AED_INTRATESQUARTERLY.DTA, replace
tsline GS10 GS1 if _n > 137, title("U.S. Treasury interest rates") 
graph export AED03FIG6.wmf, replace

****** CLOSE OUTPUT

log close
* clear
