* AED05.do March 2015 For Stata version 12 

capture log close   // capture means program continues even if no log file open
log using AED05.txt, text replace

********** OVERVIEW OF AED05.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: An Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_AGEMEANS.DTA  
*   AED_COINTOSSMEANS.DTA
* in your directory

********** SETUP **********

set more off
version 12
clear all
set mem 10m
* set linesize 82
set scheme s1manual  /* Graphics scheme */

************

* This STATA does analysis for Chapter 5
*   5.1 SAMPLING FROM A FINITE POPULATION: 1880 U.S. Census
*   5.2 POPULATION AND SAMPLE  
*   5.3 SAMPLE GENERATED BY AN EXPERIMENT: Coin Tosses
*   5.3 EXAMPLES: SAMPLING FROM A POPULATION
*   5.4 PROPERTIES OF THE SAMPLE MEAM
*   5.5 POINT ESTIMATION
*   5.6 NONRANDOM SAMPLES
*   5.? APPENDIX 5.A: SOME ESSENTIALS OF PROBABILITY
 
********** DATA DESCRIPTION

****  5.1 SAMPLING FROM A FINITE POPULATION: 1880 U.S. Census

* Figure 5.1 - elsewhere

* Figure 5.2 - panel 1 elsewhere

* Figure 5.2 - panel 2
clear
use AED_AGEMEANS.DTA
summarize
list
label variable mean "Sample mean age in years"
histogram mean, normal title("100 Sample Means")
graph export AED05FIG2B.wmf, replace

****   5.3 SAMPLE GENERATED BY AN EXPERIMENT: Coin Tosses

* Figure 5.3 - panel 1
clear
set obs 30
set seed 10101
scalar truemean = 0.5
generate x = runiform() > truemean
summarize x
label variable x "Heads = 1 and Tails = 0"
histogram x, frequency start(-0.1) width(0.2) title("One Sample of Size 30")
graph export AED05FIG3A.wmf, replace

* Figure 5.3 - panel 2
clear
use AED_COINTOSSMEANS.DTA
list in 1/5
summarize xbar
label variable xbar "Sample mean fraction of heads"
histogram xbar, normal title("400 Sample Means") saving(graph2, replace)
graph export AED05FIG3B.wmf, replace

**** APPENDIX 5.A: STANDARD NORMAL DISTRIBUTION

* Figure 5.4 - done elsewhere

********** CLOSE OUTPUT
log close


