* AED15.do March 2015 For Stata version 12 

log using AED15.txt, text replace

********** OVERVIEW OF AED15.do **********

* STATA Program 
* copyright C 2015 by A. Colin Cameron
* Used for "Analyis of Economics Data: AN Introduction to Econometrics"
* by A. Colin Cameron (2015) W.W. Norton

* To run you need file
*   AED_API99.DTA
*   AED_COBBDOUGLAS.DTA
*   AED_PHILLIPS.DTA
*   psidf3050.dat
*   psid3050.sas
* in your directory

********** SETUP **********

set more off
version 12
clear all
set scheme s1manual  // Graphics scheme

************

* This STATA program does analysis for Chapter 15
*  15.1 ACADEMIC PERFORMANCE INDEX
*  15.2 COBB DOUGLAS PRODUCTION
*  15.3 PHILLIPS CURVE
*  15.4 FROM RAW DATA TO FINA DATA
 
********** DATA DESCRIPTION

****  15.1  ACADEMIC PERFORMANCE INDEX

clear 
use AED_API99.DTA

* Table 15.1
describe
summarize

* Figure 15.1
histogram api99, kdensity title("Histogram and density estimate")
graph export AED15FIG1A.wmf, replace
kdensity api99, normal title("Density estimate and normal density")
graph export AED15FIG1B.wmf, replace

* Further analysis of api99
summarize api, detail

* Bivariate regression
regress api99 edparent
regress api99 edparent, vce(robust)

* Figure 15.2
graph twoway (scatter api99 edparent) (lfit api99 edparent), title("Academic Performance Index")
graph export AED15FIG2.wmf, replace

* Table 15.2
correlate api99 edparent meals englearn yearround credteach emerteach

* Table 15.3
regress api99 edparent meals englearn yearround credteach emerteach
test meals meals englearn yearround credteach emerteach

* Test done manually 
quietly regress api99 edparent meals englearn yearround credteach emerteach
scalar RSSu = e(rss)
scalar k = e(rank)
scalar n = e(N)
quietly regress api99 edparent
scalar RSSr = e(rss)
scalar g = e(rank)
scalar F = ((RSSr - RSSu)/(k-g)) / (RSSu/(n-k))
display "F = " F "  p = " Ftail(k-g,n-k,F) "  c = " invFtail(k-g,n-k,.05)

****  15.2 ORIGINAL COBB-DOUGLAS DATA

clear
use AED_COBBDOUGLAS.DTA, replace
describe
summarize
correlate q k l lnq lnk lnl

* Table 15.4
list q k l, clean

* Main regression
regress lnq lnk lnl

* Test Cobb and Douglas' restrictions
test lnk = .25 
test lnl = .75 
test (lnk = .25) (lnl = .75)

* Joint F Test of = .25 and = .75 done manually
gen urestrict = (lnq - .25*lnk - .75*lnl)
reg urestrict
scalar RSSr = e(rss)
scalar g = e(rank)
quietly regress lnq lnk lnl
scalar RSSu = e(rss)
scalar ku = e(rank)
scalar n = e(N)
scalar F = ((RSSr - RSSu)/(ku-g)) / (RSSu/(n-ku))
display "F = " F "  p = " Ftail(ku-g,n-ku,F) "  c = " invFtail(ku-g,n-ku,.05)

* Test constant returns to scale
test lnk + lnl = 1

* Returns to scale test done manually
gen lnqminuslnl = lnq - lnl
gen lnkminuslnl = lnk - lnl
regress lnqminuslnl lnkminuslnl
scalar RSSr = e(rss)
scalar g = e(rank)
quietly regress lnq lnk lnl
scalar RSSu = e(rss)
scalar ku = e(rank)
scalar n = e(N)
scalar F = ((RSSr - RSSu)/(ku-g)) / (RSSu/(n-ku))
display "F = " F "  p = " Ftail(ku-g,n-ku,F) "  c = " invFtail(ku-g,n-ku,.05)

* Heteroskedastic robust standard errors
regress lnq lnk lnl, vce(robust)
test (lnk = .25) (lnl = .75)
di r(F)
test lnk + lnl = 1
di r(F)

* See if autocorrelation is a problem
tsset year
quietly regress lnq lnk lnl
predict uhat, residuals
corrgram uhat

* Predict output
regress lnq lnk lnl
scalar rmse = e(rmse)
scalar b1 = _b[_cons]
scalar b2 = _b[lnk]
scalar b3 = _b[lnl]
display "For lnq: Intercept = " b1 " Coeff of lnk = " b1 " Coeff of lnl = " b2 
display "For q:   Constant  = "  exp(b1) " Power of lnk = " b1 " Power of lnl = " b2 

* Figure 15.3 - First panel
generate qpredicted = exp(rmse^2/2)*exp(b1)*k^b2*l^b3
summarize q qpredicted
correlate q qpredicted
di exp(rmse^2/2)*exp(b1)
graph twoway (line q year) (line qpredicted year), title("Predicted Output")
graph export AED15FIG3A.wmf, replace

* isoquants
scalar a = exp(_b[_cons])
scalar b2 = _b[lnk]
scalar b3 = _b[lnl]
scalar intercept = (1/a)^(1/b2)
scalar qpower = (1/b2)
scalar lpower = -(b3/b2)
display "Isoquant K = " intercept " x Q^" qpower " x L^" lpower

* Figure 15.3 - second panel
* generate isoquants
* Note that clear will drop the data but keep the scalars
clear
set obs 100
generate l = 20 +_n
generate kq80 = intercept*80^qpower*l^lpower if l > 23
generate kq100 = intercept*100^qpower*l^lpower if l > 30
generate kq120 = intercept*120^qpower*l^lpower if l > 38
summarize kq*
sort l
graph twoway (line kq80 l) (line kq100 l) (line kq120 l), title("Fitted Isoquants")
graph export AED15FIG3B.wmf, replace

****  15.3 PHILLIPS CURVE

clear 
use AED_PHILLIPS.DTA

* Table 15.5
describe
summarize

* Shorter names for figures
label variable urate "Unemployment rate"
label variable inflgdp "Annual inflation"

pwcorr urate inflgdp pastinflgdp infpgdp1yr inflcpi pastinflcpi if year < 1970
pwcorr urate inflgdp pastinflgdp infpgdp1yr inflcpi pastinflcpi if year >= 1970

* Figure 15.4
graph twoway (tsline inflgdp if year < 1970) (tsline urate if year < 1970), title("1949 to 1970 Time Series")
graph export AED15FIG4A.wmf, replace
graph twoway (scatter inflgdp urate if year < 1970) (lfit inflgdp urate if year < 1970), title("Pre-1970 Phillips Curve")
graph export AED15FIG4B.wmf, replace

* The Phillips curve before 1970
preserve
keep if year < 1970
reg inflgdp urate
predict uhat, resid
corrgram uhat, lag(5) 
newey inflgdp urate, lag(3)
reg inflgdp urate, vce(robust) 
restore

* More recent data post 1970
preserve
keep if year >= 1970

* Original curve
reg inflgdp urate
predict uhat, resid
corrgram uhat, lag(10) 
newey inflgdp urate, lag(4)
reg inflgdp urate, vce(robust) 
drop uhat

* Augmented Phillips Curve with expected inflation
reg inflgdp urate infpgdp1yr
predict uhat, resid
corrgram uhat, lag(3) 
newey inflgdp urate infpgdp1yr, lag(3)
reg inflgdp urate infpgdp1yr, vce(robust) 
drop uhat

* Figure 15.5 - first panel
graph twoway (tsline inflgdp) (tsline urate), title("1970 to 2014 Time Series")
graph export AED15FIG5A.wmf, replace
* Predicted Augmented Phillips curves
quietly reg inflgdp urate infpgdp1yr
generate pexpinfl2 = _b[_cons] + _b[urate]*urate + _b[infpgdp1yr]*2
generate pexpinfl4 = _b[_cons] + _b[urate]*urate + _b[infpgdp1yr]*4
generate pexpinfl6 = _b[_cons] + _b[urate]*urate + _b[infpgdp1yr]*6
sort urate
graph twoway (scatter inflgdp urate) (line pexpinfl6 urate) (line pexpinfl4 urate) ///
   (line pexpinfl2 urate), title("Post-1970 Augmented Phillips Curves")
graph export AED15FIG5B.wmf, replace

****  15.4 FROM RAW DATA TO REGRESSION

* Read in data
clear
infix V30001 1-4 V30002 5-7 V30809 8-9 V30820 10-11 V30821 12-17 ///
  V30823 18-21 V32000 22 V32022 23-24 V32049 25 using psidf3050.dat

* Table 15.6
summarize

* Label variables
label variable V30001  "1968 INTERVIEW NUMBER"
label variable V30002  "PERSON NUMBER"
label variable V30809  "AGE OF INDIVIDUAL 93"
label variable V30820  "G90 HIGHEST GRADE COMPLETED 93"
label variable V30821  "TOTAL LABOR INCOME 93"
label variable V30823  "1992 ANNUAL HOURS WORKED 93"
label variable V32000  "SEX OF INDIVIDUAL"
label variable V32022  "# LIVE BIRTHS TO THIS INDIVIDUAL"
label variable V32049  "LAST KNOWN MARITAL STATUS"
* Rename variables
rename V30001 intnum 
rename V30002 persnum 
rename V30809 age
rename V30820 educatn
rename V30821 earnings
rename V30823 hours
rename V32000 sex
rename V32022 kids
rename V32049 married

* Table 15.7
summarize

* Recode data
replace kids = . if kids == 98 | kids == 99
replace married = . if married == 8 | married == 9
replace educatn = . if educatn == 98 | educatn == 99
recode married (2/5=0)

* Data transformation
generate wage = earnings / hours if hours != 0 
replace wage = . if earnings == 0
gen lnwage = ln(wage)
label variable wage "Hourly wage in $ (= annual earnings / annual hours)"
label variable lnwage "Natural logarithm of wage"

* Table 15.8
sum

reg lnwage educatn

********** CLOSE OUTPUT

log close
* clear


